# Draw the underlying screen without the user drawn objects
import pygame
from Button import *
from Stack import *
from math import *
from Mode import *
import math
from os import listdir
from os.path import isfile, join

# Draw all of the basic screen elements - buttons and such
def background():
    global currentColor, screen, BLACK, tempsurface
# Draw the basic window regions
    pygame.draw.line(screen, BLACK, (0, 600), (800, 600), 2)
#    pygame.draw.line(screen, BLACK, (800, 0), (800, 600), 2)
    pygame.draw.line(screen, BLACK, (0, 0), (1100, 0), 2)
#    pygame.draw.line(screen, BLACK, (1000, 0), (1000, 700), 2)
#    pygame.draw.line(screen, BLACK, (1000, 700), (0, 700), 2)
    pygame.draw.line(screen, BLACK, (0, 700), (0, 0), 2)
    screen.blit(xsurface, (50, 630))
    screen.blit(ysurface, (50, 670))
# Draw all of the buttons
    lineButton.draw()
    circleButton.draw()
    rectButton.draw()
    textButton.draw()
    eraseButton.draw()
    saveButton.draw()
    thick1Button.draw()
    thick2Button.draw()
    thick3Button.draw()
    backButton.draw()
    foreButton.draw()
    if currentColor == (255, 255, 255):   # Draw a box with the current color
        pygame.draw.rect(screen, currentColor, pygame.Rect(700, 630, 50, 50), 1)
    else:
        pygame.draw.rect(screen, currentColor, pygame.Rect(700, 630, 50, 50))
    if mouseX <= 800 and mouseY <= 600:   # Draw the X coordinate of the mouse
        tempsurface = myfont.render(str(mouseX), False, (0, 0, 0))
        screen.blit(tempsurface, (90, 630))
        tempsurface = myfont.render(str(mouseY), False, (0, 0, 0))
        screen.blit(tempsurface, (90, 670))
# RGB of the current color
    tempsurface = myfont.render(str(currentColor[0]), False, (0, 0, 0))
    screen.blit(tempsurface, (380, 630))
    tempsurface = myfont.render(str(currentColor[1]), False, (0, 0, 0))
    screen.blit(tempsurface, (490, 630))
    tempsurface = myfont.render(str(currentColor[2]), False, (0, 0, 0))
    screen.blit(tempsurface, (600, 630))
    screen.blit (allColors, (colrX, colrY))
    screen.blit (logo, (990, 790))
    haxis()
    vaxis()
    k = 0
    c = 240
    for i in fileList:        # List of image files, starting at y=30
        tempsurface.fill((c, 0, c))
        tempsurface = myfont.render(i, False, (0,0,0))
        screen.blit(tempsurface, (810, k))
        k = k + 30
        c = c - 10
    greyBox()


def greyBox ():
    for y in range(620,875):
            k = y-620
            pygame.draw.line(screen, (k,k,k), (800, y), (850, y), 2)

def haxis():
    pygame.draw.line(screen, (0, 0, 0), (0, 600), (800, 600), 2)
    for i in range(100,800,100):
        pygame.draw.line(screen, (0, 0, 0), (i, 600), (i, 604), 2)
    for i in range(10,800,10):
        pygame.draw.line(screen, (0, 0, 0), (i, 600), (i, 602), 2)
    if mouseX <= 800:
        pygame.draw.line(screen, (0, 0, 0), (mouseX, 600), (mouseX, 606), 2)


def vaxis():
    pygame.draw.line(screen, (0, 0, 0), (800, 0), (800, 600), 2)
    for i in range(100,600,100):
        pygame.draw.line(screen, (0, 0, 0), (800, i), (804, i), 2)
    for i in range(10,600,10):
        pygame.draw.line(screen, (0, 0, 0), (800, i), (802, i), 2)
    if mouseY <= 600:
        pygame.draw.line(screen, (0, 0, 0), (800, mouseY), (806, mouseY), 2)



def checkbuttons():
    global mode, currentColor, thickness
    if lineButton.armed():
        mode = LINE
    elif circleButton.armed():
        mode = CIRCLE
    elif rectButton.armed():
        mode = RECTANGLE
    elif textButton.armed():
        mode = TEXT
    elif eraseButton.armed():
        mode = ERASE
    elif thick1Button.armed():
        thickness = 1
    elif thick2Button.armed():
        thickness = 2
    elif thick3Button.armed():
        thickness = 4
    elif saveButton.armed():
        save()
    elif foreButton.armed():
        pushstate()
    elif backButton.armed():
        popstate()

def distance(a, b):
    r = (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])
    return math.sqrt(r)


def pushstate():
    m = forestack.pop()
    if m is not None:
        backstack.push(m)


def popstate():
    m = backstack.pop()
    if m is not None:
        forestack.push(m)


def draw():
    for i in range(0, backstack.N):
        op = backstack.get(i)
        if op is None:
            return
        k = op.getkind()
        a = op.getstart()
        b = op.getend()
        t = op.getthickness()
        c = op.getcolor()
        s = op.getstring()
        if k == LINE:
            pygame.draw.line(screen, c, (a[0], a[1]), (b[0], b[1]), t)
        elif k == CIRCLE:
            r = round(distance(a, b))
            if r > t:
                pygame.draw.circle(screen, c, (a[0], a[1]), r, t)
        elif k == RECTANGLE:
            pygame.draw.rect(screen, c, (a[0], a[1], b[0]-a[0], b[1]-a[1]), t)
        elif k == TEXT:
            myfont = pygame.font.SysFont('Comic Sans MS', 30)
            t = myfont.render(s, False, c)
            screen.blit(t, a)
        elif k == ERASE:
            pygame.draw.rect(screen, (255, 255, 255), (a[0], a[1], b[0]-a[0], b[1]-a[1]), 0)
        elif k == IMAGE:
            imag = b[0]
            xx,yy = imag.get_size()
            if xx > 800:
                xx = 800
            if yy > 600:
                yy = 600
            screen.blit(imag.subsurface(0,0,xx,yy), (2, 2))

def filenameScan():
    k = (trunc(mouseY)//30)
    y = k * 30
    pygame.draw.rect(screen, (255, 0, 0), (800, y, 100, y), 1)
    return k


def dist2 (a, b, x, y):
    return sqrt( (a-x)*(a-x) + (b-y)*(b-y) )

def save():
    pygame.image.save(screen.subsurface((0,0,800,600)), "out.png")


screen = pygame.display.set_mode((1100, 900))  # Notice the tuple! It's not 2 arguments.
clock = pygame.time.Clock()
pygame.font.init()
myfont = pygame.font.SysFont('Times Roman', 30)
xsurface = myfont.render('X', False, (0, 0, 0))
ysurface = myfont.render("Y", False, (0, 0, 0))
FPS = 60  # This variable will define how many frames we update per second.
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)

# Initialize the images for the buttons
imageLine = pygame.Surface((42, 42))            # Draw line
imageLine.fill((200, 200, 200))
pygame.draw.line(imageLine, BLACK, (3, 3), (38, 38), 2)
imageT1 = pygame.Surface((42, 42))  # Line size 1
imageT1.fill((200, 200, 200))
pygame.draw.line(imageT1, BLACK, (3, 21), (38, 21), 1)
imageT2 = pygame.Surface((42, 42))  # Line size 2
imageT2.fill((200, 200, 200))
pygame.draw.line(imageT2, BLACK, (3, 21), (38, 21), 2)
imageT3 = pygame.Surface((42, 42))  # Line size 3
imageT3.fill((200, 200, 200))
pygame.draw.line(imageT3, BLACK, (3, 21), (38, 21), 4)
imageCircle = pygame.Surface((42, 42))
imageCircle.fill((200, 200, 200))
pygame.draw.circle(imageCircle, BLACK, (20, 20), 10, 2)
imageRect = pygame.Surface((42, 42))
imageRect.fill((200, 200, 200))
pygame.draw.rect(imageRect, BLACK, (12, 12, 18, 18), 2)
imageErase = pygame.image.load("erase.png")
imageSave = pygame.image.load("save.png")
imageBack = pygame.image.load("back.png")
imageFore = pygame.image.load("fore.png")
imageText = pygame.image.load("text.png")
allColors = pygame.image.load("colorss.png")
logo = pygame.image.load("logo.png")
# Initialize all of the buttons
lineButton = Button(screen, 20, 750, 50, 50)      # Select a line to draw
lineButton.set_image(imageLine)
circleButton = Button(screen, 80, 750, 50, 50)    # Select a circle
circleButton.set_image(imageCircle)
rectButton = Button(screen, 140, 750, 50, 50)
rectButton.set_image(imageRect)
textButton = Button(screen, 200, 750, 50, 50)
textButton.set_image(imageText)
eraseButton = Button(screen, 260, 750, 50, 50)
eraseButton.set_image(imageErase)

thick1Button = Button(screen, 20, 830, 50, 50)
thick1Button.set_image(imageT1)
thick2Button = Button(screen, 80, 830, 50, 50)
thick2Button.set_image(imageT2)
thick3Button = Button(screen, 140, 830, 50, 50)
thick3Button.set_image(imageT3)
saveButton = Button(screen, 200, 830, 50, 50)
saveButton.set_image(imageSave)
backButton = Button(screen, 260, 830, 50, 50)
backButton.set_image(imageBack)
foreButton = Button(screen, 320, 830, 50, 50)
foreButton.set_image(imageFore)

currentColor = (0, 0, 0)

thickness = 1
LINE = 100
CIRCLE = 101
RECTANGLE = 102
TEXT = 103
ERASE = 104
IMAGE = 105
mode = LINE
mouseDownX = 0
mouseDownY = 0
mouseUpX = 0
mouseUpY = 0
backstack = Stack()
forestack = Stack()
down = False
colrX = 500
colrY = 680
textInput = False

allFiles = listdir(".") # Create a list of image files
fileList = []
for i in allFiles:
    if i[-3:]=="jpg" or i[-3:]=="png":
        fileList.append(i)

while True:
    clock.tick(FPS)
    mouze = pygame.mouse.get_pos()
    mouseX = mouze[0]
    mouseY = mouze[1]
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()
        if event.type == pygame.MOUSEBUTTONDOWN and not down:
            if mouseX < 0 or mouseX > 800:
                continue
            if mouseY < 0 or mouseY > 600:
                continue
            mouseDownX = mouseX
            mouseDownY = mouseY
            down = True
            if mode == TEXT:
                thisdraw = Mode(mode, [mouseDownX, mouseDownY], "", currentColor, thickness)
            else:
                thisdraw = Mode(mode, [mouseDownX, mouseDownY], [mouseDownX, mouseDownY], currentColor, thickness)
            backstack.push(thisdraw)
        elif down:
            if mouseX < 0 or mouseX > 800:
                continue
            if mouseY < 0 or mouseY > 600:
                continue
            if mode == LINE:
                old = backstack.top().setend([mouseX, mouseY])
            elif mode == CIRCLE:
                old = backstack.top().setend([mouseX, mouseY])
            elif mode == RECTANGLE:
                old = backstack.top().setend([mouseX, mouseY])
            elif mode == ERASE:
                old = backstack.top().setend([mouseX, mouseY])
        if event.type == pygame.MOUSEBUTTONUP:     # Mouse button was released
            down = False
            dist = dist2(mouseX, mouseY, colrX+100, colrY+100)  # How far from center of color wheel?
            if dist < 86:
                currentColor = screen.get_at((mouseX, mouseY))
                continue
            if mouseX > 800 and mouseX <850 and mouseY>=620 and mouseY<=875:
                 currentColor = screen.get_at((mouseX, mouseY))
                 continue
            if checkbuttons():
                continue
            if mode == TEXT:
                textInput = True
                textString = ""
#                thisdraw = Mode(mode, [mouseDownX, mouseDownY], "", currentColor, thickness)
#f                backstack.push(thisdraw)
            if mouseX > 800 and mouseY<(len(fileList))*30:
                k = filenameScan()
                imag = pygame.image.load(fileList[k])
                thisdraw = Mode(IMAGE, [0,0], [imag], currentColor, thickness)
                backstack.push(thisdraw)
        elif event.type == pygame.KEYDOWN:
            if textInput:
                if event.key == event.key==pygame.K_RETURN:
                    textInput = False
                elif event.key == pygame.K_BACKSPACE:
                    if len(textString) > 0:
                        textString = textString[0:-1]
                        old = backstack.top().setstring(textString)
                else:
                    textString = textString + chr(event.key)
                    old = backstack.top().setstring(textString)

    screen.fill(WHITE)
    background()            # Draw the paint window
    draw()
    pygame.display.update()  # redraw the screen
